/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.managed.ManagedObjectProperties;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.ui.UIHwmcaObject;
import com.ibm.hwmca.fw.ui.UIInfo;
import java.util.HashSet;
import java.util.Set;

public class UIManagedObject
extends UIHwmcaObject
implements ManagedObjectProperties {
    private boolean busy;
    private Status status;
    private HashSet acceptableStatus;

    public UIManagedObject(ObjectId objectId, UIInfo uiInfo, Set acceptableStatus, Status status, boolean busy) {
        super(objectId, uiInfo);
        if (acceptableStatus != null) {
            this.acceptableStatus = new HashSet(acceptableStatus);
        }
        this.status = status;
        this.busy = busy;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        if (this.busy != busy) {
            boolean oldBusy = this.busy;
            this.busy = busy;
            if (this.propertyChangeSupport != null) {
                this.propertyChangeSupport.firePropertyChange("Busy", new Boolean(oldBusy), new Boolean(busy));
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        if (this.status != status) {
            Status oldStatus = this.status;
            this.status = status;
            if (this.propertyChangeSupport != null) {
                this.propertyChangeSupport.firePropertyChange("Status", oldStatus, status);
            }
        }
    }

    public boolean isStatusAcceptable() {
        if (this.acceptableStatus == null) {
            return false;
        }
        return this.acceptableStatus.contains(this.status);
    }
}

